<!DOCTYPE html>
<html lang="english">

<head>
    <?php include("head.php"); ?>
    <?php include("module/service.php"); ?>
    <link href="assets/stylesheet/jquery.growl.css" rel="stylesheet" type="text/css" />
    <?php include("module/usercheck.php"); ?>
    <!-- check user login or not	 -->

</head>

<body class="blue-skin">
    <!-- ============================================================== -->
    <!-- Preloader - style you can find in spinners.css -->
    <!-- ============================================================== -->
    <div id="preloader">
        <div class="preloader"><span></span><span></span></div>
    </div>

    <!-- ============================================================== -->
    <!-- Main wrapper - style you can find in pages.scss -->
    <!-- ============================================================== -->
    <div id="main-wrapper">

        <!-- ============================================================== -->
        <!-- Top header  -->
        <!-- ============================================================== -->
        <!-- Start Navigation -->
        <?php include("header1.php"); ?>
        <!-- End Navigation -->
        <div class="clearfix"></div>
        <!-- ============================================================== -->
        <!-- Top header  -->
        <!-- ============================================================== -->

        <!-- ============================ Page Title Start================================== -->
        <div class="page-title">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12">

                        <h2 class="ipt-title">Submit Property</h2>
                        <span class="ipn-subtitle">Just Submit Your Property</span>

                    </div>
                </div>
            </div>
        </div>
        <!-- ============================ Page Title End ================================== -->

        <!-- ============================ Submit Property Start ================================== -->
        <section class="gray-simple">

            <div class="container">
                <div class="row login-form">

                    <!-- Submit Form -->
                    <form action="" method="post" enctype="multipart/form-data">
                        <div class="col-lg-12 col-md-12">

                            <div class="submit-page">

                                <!-- Basic Information -->
                                <div class="form-submit">
                                    <h3>Basic Information</h3>
                                    <div class="submit-section">
                                        <div class="row">

                                            <div class="form-group col-md-12">
                                                <label>Property Title<span class="tip-topdata"
                                                        data-tip="Property Title"><i class="ti-help"></i></span></label>

                                                <input type="text" name="property_name" id="" class="form-control"
                                                    placeholder="Enter Property Name" required />
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Property Type</label>
                                                <select id="property_type" name="property_type" class="form-control"
                                                    required>
                                                    <?php
                                                            $sql = "SELECT a.* from  property_type_main a where transaction_status = '1'  order by service_name ASC";
                                                            $qy = $con->prepare($sql);
                                                            $qy->execute();
                                                            if ($qy->rowCount() > 0) {
                                                        ?>

                                                    <option value="">Select Property Type</option>
                                                    <?php
                                                                while ($row = $qy->fetch(PDO::FETCH_ASSOC)) {
                                                                    //echo json_encode($row);
                                                                ?>
                                                    <option value="<?php echo $row['pk_service_code']; ?>">
                                                        <?php echo $row['service_name']; ?></option>
                                                    <?php
                                                                }
                                                            } else {
                                                                ?>
                                                    <option value="">NA</option>
                                                    <?php
                                                            }
                                                        ?>
                                                </select>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Construction Status</label>
                                                <select id="construction_status" name="construction_status"
                                                    class="form-control" required>
                                                    <?php
                                                            $sql = "SELECT a.* from  construction_status a where transaction_status = '1'  order by construction_status_name ASC";
                                                            $qy = $con->prepare($sql);
                                                            $qy->execute();
                                                            if ($qy->rowCount() > 0) {
                                                        ?>

                                                    <option value="">Select Construction Status</option>
                                                    <?php
                                                                while ($row = $qy->fetch(PDO::FETCH_ASSOC)) {
                                                                    //echo json_encode($row);
                                                                ?>
                                                    <option value="<?php echo $row['id']; ?>">
                                                        <?php echo $row['construction_status_name']; ?></option>
                                                    <?php
                                                                }
                                                            } else {
                                                                ?>
                                                    <option value="">NA</option>
                                                    <?php
                                                            }
                                                        ?>
                                                </select>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Select Service Type</label>
                                                <select id="service_type" name="service_type" class="form-control"
                                                    required>
                                                    <option value="">Please Select Service Type</option>
                                                </select>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Select Service Category</label>
                                                <select id="service_category" name="service_category"
                                                    class="form-control">
                                                    <option value="">Please Select Service Category</option>
                                                </select>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Price</label>

                                                <input type="number" name="price" id="" class="form-control"
                                                    placeholder="Price (in Rs)" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Area</label>
                                                <input type="number" name="area_no" id="" placeholder="Area(in numbers)"
                                                    class="form-control" required>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Select Area Unit</label>
                                                <select id="area_unit" name="area_unit" class="form-control" required>
                                                    <?php
                                                            $sql = "SELECT a.* from  area_unit a where transaction_status = '1'  order by area_unit_name	 ASC";
                                                            $qy = $con->prepare($sql);
                                                            $qy->execute();
                                                            if ($qy->rowCount() > 0) {
                                                        ?>

                                                    <option value="">Select Area Unit</option>
                                                    <?php
                                                                while ($row = $qy->fetch(PDO::FETCH_ASSOC)) {
                                                                    //echo json_encode($row);
                                                                ?>
                                                    <option value="<?php echo $row['id']; ?>">
                                                        <?php echo $row['area_unit_name']; ?></option>
                                                    <?php
                                                                }
                                                            } else {
                                                                ?>
                                                    <option value="">NA</option>
                                                    <?php
                                                            }
                                                        ?>
                                                </select>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Select Bedroom Type</label>

                                                <select id="bedrooms" name="bedroom" class="form-control" required>
                                                    <?php
                                                            $sql = "SELECT a.* from  cnf_mst_bedroom_type a where transaction_status = '1'  order by destination_type_name ASC";
                                                            $qy = $con->prepare($sql);
                                                            $qy->execute();
                                                            if ($qy->rowCount() > 0) {
                                                        ?>

                                                    <option value="">Select Bedroom </option>
                                                    <?php
                                                                while ($row = $qy->fetch(PDO::FETCH_ASSOC)) {
                                                                    //echo json_encode($row);
                                                                ?>
                                                    <option value="<?php echo $row['id']; ?>">
                                                        <?php echo $row['destination_type_name']; ?></option>
                                                    <?php
                                                                }
                                                            } else {
                                                                ?>
                                                    <option value="">NA</option>
                                                    <?php
                                                            }
                                                        ?>
                                                </select>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>No. of Bathrooms</label>

                                                <select id="bathrooms" name="bathroom" class="form-control" required>
                                                    <option value="">Select Bathroom </option>
                                                    <option value="0">0</option>
                                                    <option value="1">1</option>
                                                    <option value="2">2</option>
                                                    <option value="3">3</option>
                                                    <option value="4">4</option>
                                                    <option value="5">5</option>
                                                    <option value="6">6</option>
                                                    <option value="7">7</option>
                                                    <option value="8">8</option>
                                                    <option value="9">9</option>
                                                    <option value="10">10</option>
                                                    <option value="11">11</option>
                                                    <option value="12">12</option>
                                                    <option value="13">13</option>
                                                    <option value="14">14</option>
                                                    <option value="15">15</option>
                                                    <option value="16">16</option>
                                                    <option value="17">17</option>
                                                    <option value="18">18</option>
                                                    <option value="19">19</option>
                                                    <option value="20">20</option>


                                                </select>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>No. of Balconies</label>
                                                <select id="balconies" name="balconies" class="form-control" required>
                                                    <option value="">Select Balconies </option>
                                                    <option value="0">0</option>
                                                    <option value="1">1</option>
                                                    <option value="2">2</option>
                                                    <option value="3">3</option>
                                                    <option value="4">4</option>
                                                    <option value="5">5</option>
                                                    <option value="6">6</option>
                                                    <option value="7">7</option>
                                                    <option value="8">8</option>
                                                    <option value="9">9</option>
                                                    <option value="10">10</option>
                                                    <option value="11">11</option>
                                                    <option value="12">12</option>
                                                    <option value="13">13</option>
                                                    <option value="14">14</option>
                                                    <option value="15">15</option>
                                                    <option value="16">16</option>
                                                    <option value="17">17</option>
                                                    <option value="18">18</option>
                                                    <option value="19">19</option>
                                                    <option value="20">20</option>


                                                </select>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <!-- Gallery -->
                                <div class="form-submit">
                                    <h3>Gallery</h3>
                                    <div class="submit-section">
                                        <div class="row">
                                            <div class="form-group col-md-6">

                                                <label>Upload Icon Image</label>
                                                <input type="file" name="icon" id="" class="form-control" required>

                                            </div>
                                            <div class="form-group col-md-6">

                                                <label>Upload Cover Image</label>
                                                <input type="file" name="cover" id="" class="form-control" required>

                                            </div>
                                            <div class="form-group col-md-12">
                                                <label>Upload Gallery</label><small style="color:red">You can upload
                                                    multiple images</small>


                                                <input name="image[]" type="file" id="coverimg_sub" class="form-control"
                                                    multiple>


                                            </div>


                                        </div>
                                    </div>
                                </div>

                                <!-- Location -->
                                <div class="form-submit">
                                    <h3>Location</h3>
                                    <div class="submit-section">
                                        <div class="row">

                                            <div class="form-group col-md-6">
                                                <label>Address</label>
                                                <input type="text" name="address" class="form-control">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>City</label>
                                                <input type="text" name="city" class="form-control">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Country</label>
                                                <select id="country" name="country" class="form-control" required>
                                                    <option value="">Please Select</option>
                                                </select>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>State</label>
                                                <select id="state" name="state" class="form-control">
                                                    <option value="">Select State</option>
                                                </select>

                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Zip Code</label>
                                                <input type="text" name="zip" class="form-control">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Detailed Information -->
                                <div class="form-submit">
                                    <h3>Detailed Information</h3>
                                    <div class="submit-section">
                                        <div class="row">

                                            <div class="form-group col-md-12">
                                                <label>Short Description</label>
                                                <input type="text" name="short_des" id="" class="form-control">
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label>Roof</label>
                                                <!-- <select id="bage" class="form-control">
                                                    <option value="">&nbsp;</option>
                                                    <option value="1">0 - 5 Years</option>
                                                    <option value="2">0 - 10Years</option>
                                                    <option value="3">0 - 15 Years</option>
                                                    <option value="4">0 - 20 Years</option>
                                                    <option value="5">20+ Years</option>
                                                </select> -->
                                                <select id="furnishing" name="roof" class="form-control" required>
                                                    <option value="">Select Roof Status</option>
                                                    <option value="1">Yes</option>
                                                    <option value="0">No</option>
                                                </select>
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label>Furnishing Status</label>
                                                <select id="furnishing" name="furnishing_status" class="form-control"
                                                    required>
                                                    <option value="">Select Balconies </option>
                                                    <option value="1">Unfurnished</option>
                                                    <option value="2">Semi-Furnished</option>
                                                    <option value="3">Furnished</option>
                                                </select>
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label>Property Facing</label>
                                                <select id="facing" name="facing" class="form-control" required>
                                                    <option value="">Select Property Facing </option>
                                                    <option value="North">North</option>
                                                    <option value="South">South</option>
                                                    <option value="East">East</option>
                                                    <option value="West">West</option>
                                                    <option value="North-East">North-East</option>
                                                    <option value="North-West">North-West</option>
                                                    <option value="South-East">South-East</option>
                                                    <option value="South-West">South-West</option>
                                                </select>
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label>Parking</label>
                                                <select id="parking" name="parking" class="form-control" required>
                                                    <option value="">Select Parking Status</option>
                                                    <option value="1">Yes</option>
                                                    <option value="0">No</option>
                                                </select>
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label>Total Floors</label>
                                                <input type="number" name="total_floor" id="total_floor"
                                                    class="form-control">
                                                <div id="result"></div>
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label>Property on Floors</label>
                                                <select id="pfloor" name="pfloor" class="form-control" required>
                                                    <option value="">Property on Floors </option>

                                                </select>
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label>Age Of Property</label>
                                                <select id="agep" name="agep" class="form-control" required>
                                                    <option value="">Select Age of property </option>
                                                    <option value="0">0-1 year</option>
                                                    <option value="1">1-5 year</option>
                                                    <option value="2">5-10 year</option>
                                                    <option value="3">10+ year</option>


                                                </select>
                                            </div>
                                            <div class="form-group col-md-12">
                                                <label>Aminities</label>
                                                <div class="o-features">
                                                    <ul class="no-ul-list third-row">
                                                        <?php
                                                            $sql = "SELECT a.* from  aminity a where transaction_status = '1'  ";
                                                            $qy = $con->prepare($sql);
                                                            $qy->execute();
                                                            if ($qy->rowCount() > 0) {
                                                                while ($row = $qy->fetch(PDO::FETCH_ASSOC)) {

                                                        ?>
                                                        <li>


                                                            <input id="<?php echo $row['id'];?>"
                                                                value="<?php echo $row['id'];?>" class="checkbox-custom"
                                                                name="aminity[]" type="checkbox">
                                                            <label for="<?php echo $row['id'];?>"
                                                                class="checkbox-custom-label"><?php echo $row['aminity_name'];?></label>
                                                        </li>
                                                        <?php }
                                                            }
                                                            ?>

                                                    </ul>
                                                </div>
                                            </div>
                                            <div class="form-group col-md-12">

                                                <label>Property Details</label>
                                                <textarea name="long_detail" class="form-control"></textarea>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <!-- Contact Information -->
                            <div class="form-submit">
                                <h3>Contact Information</h3>
                                <div class="submit-section">
                                    <div class="row">

                                        <div class="form-group col-md-4">
                                            <label>Name</label>
                                            <input type="text" name="userid" class="form-control">

                                            <input type="text" name="name" class="form-control">
                                        </div>

                                        <div class="form-group col-md-4">
                                            <label>Email</label>
                                            <input type="text" name="email" class="form-control">
                                        </div>

                                        <div class="form-group col-md-4">
                                            <label>Phone (optional)</label>
                                            <input type="text" name="phone" class="form-control">
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-lg-12 col-md-12">
                                <label>GDPR Agreement *</label>
                                <ul class="no-ul-list">
                                    <li>
                                        <input id="aj-1" class="checkbox-custom" name="aj-1" type="checkbox" required>
                                        <label for="aj-1" class="checkbox-custom-label">I consent to having this
                                            website store my submitted information so they can respond to my
                                            inquiry.</label>
                                    </li>
                                </ul>
                            </div>

                            <div class="form-group col-lg-12 col-md-12">
                                <button class="btn btn-theme-light-2 rounded" name="submit" type="submit">Submit
                                </button>
                            </div>

                        </div>
                    </form>
                </div>

            </div>
    </div>

    </section>
    <!-- ============================ Submit Property End ================================== -->





    <a id="back2Top" class="top-scroll" title="Back to top" href="#"><i class="ti-arrow-up"></i></a>


    </div>
    <!-- ============================================================== -->
    <!-- End Wrapper -->
    <!-- ============================================================== -->

    <?php include("footer.php"); ?>
    <!-- ============================================================== -->
    <!-- All Jquery -->
    <!-- ============================================================== -->
    <?php include("foot.php"); ?>
    <!-- ============================================================== -->
    <!-- This page plugins -->
    <!-- ============================================================== -->


    <script src="assets/js/dropzone.js"></script>
    <!-- New Js -->
    <script src="ajax/country.js" type="text/javascript"></script>
    <script src="https://prs.cryoliteindia.com/modules/SRM_Management/js/service_list.js"></script>

    <script type="text/javascript">
    $('#total_floor').on('change', function() {

        var total_floor = $(this).val();

        if (total_floor) {
            $.ajax({
                type: 'POST',
                url: 'https://prs.cryoliteindia.com/modules/SRM_Management/ajaxpage/get_data.php',
                data: 'total_floor=' + total_floor,
                success: function(html) {
                    $("#pfloor").html(html);
                }
            });
        } else {
            //alert('Ajax Error');
        }
    });
    </script>


    <?php
if (isset($_POST['submit'])) {?>

    <?php
   if(empty($_POST['property_type'])){?>
    <script>
    $(document).ready(function() {
        $.growl.error({
            message: "Property Type Required..!!"
        });
    });
    </script>
    <?php
   }elseif (empty($_POST['property_name'])) {?>
    <script>
    $(document).ready(function() {
        $.growl.error({
            message: "Property Name Required..!!"
        });
    });
    </script>
    <?php
   }elseif (empty($_POST['construction_status'])) {?>
    <script>
    $(document).ready(function() {
        $.growl.error({
            message: "Construction Status  Required..!!"
        });
    });
    </script>
    <?php    

       
                 
 
   
   }elseif(empty($_POST['price'])){?>
    <script>
    $(document).ready(function() {
        $.growl.error({
            message: "Pricing Required..!!"
        });
    });
    </script>

    <?php
 

   }else{
       if (!empty($_FILES['icon']['size']) && !empty($_FILES['cover']['size'])) {
           $property_type=trim($_POST['property_type']);     
           $property_name=trim($_POST['property_name']);         
           $construction_status=trim($_POST['construction_status']);     
           $country=trim($_POST['country']);     
           $state=trim($_POST['state']);     
           $service_type=trim($_POST['service_type']);      
           $service_category=trim($_POST['service_category']);      
           $price=trim($_POST['price']);     
           $area_no=trim($_POST['area_no']);     
           $area_unit=trim($_POST['area_unit']);     
           $bedroom=trim($_POST['bedroom']);     
           $bathroom=trim($_POST['bathroom']);     
           $balconies=trim($_POST['balconies']);     
           $roof=trim($_POST['roof']);     
           $furnishing_status=trim($_POST['furnishing_status']);     
           $facing=trim($_POST['facing']);     
           $parking=trim($_POST['parking']);     
           $total_floor=trim($_POST['total_floor']);     
           $pfloor=trim($_POST['pfloor']);     
           $agep=trim($_POST['agep']);     
           $short_des=trim($_POST['short_des']);       
           $long_detail=trim($_POST['long_detail']);                           
           $fdate=date("Y-m-d"); 
           $add_by=$userid1;
           $address=trim($_POST['address']);
           $city=trim($_POST['city']);
           $zip=trim($_POST['zip']);
           // $aminity=trim($_POST['aminity']);  
  
           //icon
           $file=$_FILES['icon']['name'];
           $fileNewName="icon".mt_rand(1000,9999);
           $foldername="property_image/";
           $ext=pathinfo($_FILES['icon']['name'],PATHINFO_EXTENSION);
           $newfilename=$fileNewName.'.'.$ext;
           $extension=array("jpeg", "jpg", "png");
           //cover
           $file1=$_FILES['cover']['name'];
           $fileNewName1="cover".mt_rand(1000,9999);
           $foldername1="property_image/";
           $ext1=pathinfo($_FILES['cover']['name'],PATHINFO_EXTENSION);
           $newfilename1=$fileNewName1.'.'.$ext1;

           if(in_array($ext,$extension) && in_array($ext1,$extension)){
               $check=$service_query->check_property($con,$property_type,$property_name,$country,$state);
               if($check>0){?>
                    <script>
                    $(document).ready(function() {
                        $.growl.error({
                            message: "Property Already Exist..!!"
                        });
                    });
                    </script>
                    <?php    
               }else{
                   $insdata=$service_query->ins_property($con,$property_type,$property_name,$fdate,$construction_status,$country,
                   $state,$service_type,$service_category,$price,$area_no,$area_unit,$bedroom,$bathroom,$balconies,$roof,
                   $furnishing_status,$facing,$parking,$total_floor,$pfloor,$agep,$short_des,$newfilename,$newfilename1,
                   $long_detail,$add_by,$address,$city,$zip);
                   if(empty($insdata)){
                                        $_POST = array();?>
                        <script>
                        $(document).ready(function() {
                            $.growl.error({
                                message: "Data Not Added..!!"
                            });
                        });
                        </script>
                        <?php    
                   }else{
                       move_uploaded_file($_FILES['icon']['tmp_name'],$foldername.$fileNewName.'.'.$ext);
                       move_uploaded_file($_FILES['cover']['tmp_name'],$foldername1.$fileNewName1.'.'.$ext1);
                       $property_id=$insdata;                       

                       //multi image upload property_id add table cnf_mst_property_master
                       $extension = array("jpeg", "jpg", "png");
                       foreach ($_FILES["image"]["tmp_name"] as $key => $tmp_name) {
                           $file_name = $_FILES["image"]["name"][$key];
                           $file_tmp = $_FILES["image"]["tmp_name"][$key];
                           $ext = pathinfo($file_name, PATHINFO_EXTENSION);
                   
                           if (in_array($ext, $extension)) {
                               $temp = explode(".", $file_name);
                               $newfilename = "image_" . mt_rand(1000, 9999) . '.' . end($temp);
                               if (move_uploaded_file($file_tmp = $_FILES["image"]["tmp_name"][$key], "property_image/" . $newfilename)) {
                                   $row_img=$service_query->ins_gallery_image($con,$property_id,$newfilename);
                                   if ($row_img>0) {
                                       ?>
                                    <script>
                                    $(document).ready(function() {
                                        $.growl.notice({
                                            message: "Gallery Image Uploaded..!!"
                                        });
                                    });
                                    </script>
                                    <?php
                                   
                                   } else {
                                       ?>
                                    <script>
                                    $(document).ready(function() {
                                        $.growl.error({
                                            message: "Gallery Image Not Uploaded..!!"
                                        });
                                    });
                                    </script>
                                    <?php
                                   
                                   }


                               } else {
                                   
                               }
                           } else {
                               ?>
                                <script>
                                $(document).ready(function() {
                                    $.growl.error({
                                        message: "Gallery Image not uploaded. Invalid Gallery Image..!!"
                                    });
                                });
                                </script>
                                <?php    
                           
                           }
                       }
                       //aminities add table property_aminity
                       if(!empty($_POST['aminity'])){
                        // Loop to store and display values of individual checked checkbox.
                            foreach($_POST['aminity'] as $aminityselected){
                                $row_aminity=$service_query->ins_property_aminity($con,$property_id,$aminityselected);
                            }
                        }
                        //user added with property

                       ?>
                                <script>
                                $(document).ready(function() {
                                    $.growl.notice({
                                        message: "Property added successfully...!!"
                                    });
                                });
                                </script>
                                <?php 
                   }

               }



           }else{
               ?>
                    <script>
                    $(document).ready(function() {
                        $.growl.error({
                            message: "Invalid Image..Data not Uploaded!!"
                        });
                    });
                    </script>
                    <?php 
                        }

          

  
       }else{
           ?>
            <script>
            $(document).ready(function() {
                $.growl.error({
                    message: "Cover or Icon Image Required!!"
                });
            });
            </script>
            <?php 
            }
   }
}

?>

    <script src="assets/javascript/jquery.growl.js" type="text/javascript"></script>

</body>

</html>