filter_data();

function filter_data() {

    $('.filter_data').html('<div id="loading" style="" ></div>');
    var action = 'fetch_data';
    var minimum_price = $('#hidden_minimum_price').val();
    var maximum_price = $('#hidden_maximum_price').val();
    var minimum_area = $('#hidden_minimum_area').val();
    var maximum_area = $('#hidden_maximum_area').val();
    var areaunit = $('#areaunit').find(":selected").val();
    var bedrooms = get_filter('bedrooms');

    var ram = get_filter('ram');
    var aminity = get_filter('aminity');
    $.ajax({

        url: "module/fetch_data.php",
        method: "POST",
        data: {
            action: action,
            minimum_price: minimum_price,
            maximum_price: maximum_price,
            minimum_area: minimum_area,
            maximum_area: maximum_area,
            areaunit: areaunit,
            bedrooms: bedrooms,
            ram: ram,
            aminity: aminity
        },
        success: function(data) {
            $('.filter_data').html(data);
        }
    });
}

function get_filter(class_name) {
    var filter = [];
    //var filter1 = [];
    $('.' + class_name + ':checked').each(function() {
        filter.push($(this).val());
    });
    return filter;
}

$('.common_selector').click(function() {
    filter_data();
});

$('#price_range').slider({

    range: true,
    min: 0,
    max: 1000000,
    values: [0, 1000000],
    step: 100,
    stop: function(event, ui) {
        $('#price_show').html(ui.values[0] + ' - ' + ui.values[1]);
        $('#hidden_minimum_price').val(ui.values[0]);
        $('#hidden_maximum_price').val(ui.values[1]);

        filter_data();
    }
});

$('#area_range').slider({
    range: true,
    min: 0,
    max: 4000,
    values: [0, 4000],
    step: 10,
    stop: function(event, ui) {
        $('#area_show').html(ui.values[0] + ' - ' + ui.values[1]);
        $('#hidden_minimum_area').val(ui.values[0]);
        $('#hidden_maximum_area').val(ui.values[1]);
        filter_data();
    }
});